#  dummy to load file  #
proc perlEngine.tcl {} {}

#############################################################################
#  running scripts  #
# Tell MacPerl to run a script file:
#
proc perlExecuteFile {path {args {}} {flags {}}} {
	global PerlmodeVars ALPHA scriptFile scriptStart filterHeadLen perlName
	
	if {[string length $path]} {
		set perlName [file tail [app::launchBack McPL]]
		if {[string length $perlName]} {
				
			set ok [regexp {(.*):([^:]*)} $path pathname dirname filename]
			if {!$ok} {	set name $wname	}

			if {$path != [scriptPath]} {	
				set filterHeadLen 0	
			}
			
			if {$PerlmodeVars(perluseDebugger)} {
				append flags "debug"
			}
			if {$PerlmodeVars(perlpromptForArgs)} { 
				append args " [getCmdlineArgs]"
			}
			
			sendCloseWinName $perlName $perlName
			sendCloseWinName $perlName "Perl Debug"
			if {$PerlmodeVars(perlautoSwitch) || $PerlmodeVars(perluseDebugger)} {
				switchTo $perlName
			} else {
				message "Running file \"$filename\" as Perl script"
				watchCursor
			}
			
			perlDoScript $perlName $path $args {} $flags
			
# (not sure which choice is better...)
#			if {!$PerlmodeVars(perlautoSwitch)} {switchTo $ALPHA}
			switchTo $ALPHA
#
            if {![getMacPerlError]} {
            	if {$PerlmodeVars(perlretrieveOutput)} {openPerlOutput}
            }
	    } else {
			alertnote "Couldn't run MacPerl"
	    }
	} else {
		alertnote "No file specified to execute"
	}
}

#############################################################################
# Run a MacPerl script, passed explicitly as a string:
#
# If no "#!/bin/perl" line already exists, one is preprended to the script
# by wrapSelectScript, which also sets $filterHeadLen for use by 
# getMacPerlError.
# 
proc perlExecuteScript {script {args ""} {flags {}} } {
	global PerlmodeVars perlName
	global scriptFile scriptStart filterHeadLen  ALPHA
	
	if {$script != ""} {
		set script [wrapSelectScript $script]
		
		if {![regexp {(.*):([^:]*)} $scriptFile pathname dirname filename]} {
			set filename $scriptFile 
		}

		set perlName [file tail [app::launchBack McPL]]
		if {[string length $perlName]} {
		
			if {$PerlmodeVars(perluseDebugger)} {
				append flags "debug"
			}
			if {$PerlmodeVars(perlpromptForArgs)} { 
				append args " [getCmdlineArgs]"
			}
			
			sendCloseWinName $perlName $perlName
			sendCloseWinName $perlName "Perl Debug"
			if {$PerlmodeVars(perlautoSwitch) || $PerlmodeVars(perluseDebugger)} {
				switchTo $perlName
			} else {
				message "Running buffer \"$filename\" as Perl script"
				watchCursor
			}
			
			perlDoScript $perlName $script $args {} $flags
			
			switchTo $ALPHA

            if {![getMacPerlError]} {
            	if {$PerlmodeVars(perlretrieveOutput)} {openPerlOutput}
            }
        }
		
	} else {
			alertnote "Can't run an empty script"
	}
}

#############################################################################
# Run a MacPerl script from the Tcl shell
#
# This proc pretends it is the invocation of the perl app when used 
# as the first word of a command in the Tcl shell. -trf
# 
proc perl {{path {}} {args {}} } {
	global PerlmodeVars ALPHA scriptFile scriptStart filterHeadLen perlName
	set flags {}
	
	if {[string length $path]} {
		set perlName [file tail [app::launchBack McPL]]
		if {[string length $perlName]} {
				
			set filename [file tail $path]
			if {$path != [scriptPath]} {	
				set filterHeadLen 0	
			}
			
			sendCloseWinName $perlName $perlName
			sendCloseWinName $perlName "Perl Debug"
			if {$PerlmodeVars(perlautoSwitch) || $PerlmodeVars(perluseDebugger)} {
				switchTo $perlName
			} else {
				message "Running file \"$filename\" as Perl script"
				watchCursor
			}
			
			perlDoScript $perlName $path $args {} $flags
			
			switchTo $ALPHA

			if {![getMacPerlError]} {
            	if {$PerlmodeVars(perlretrieveOutput)} {openPerlOutput}
            }
	    } else {
			alertnote "Couldn't run MacPerl"
	    }
	} else {
		echo {Usage:  perl <filename> [ <args> ]}
	}
}


#  check MacPerl error msg  #
#############################################################################
# Check the MacPerl output window for error messages.
#
proc getMacPerlError {} {
	
	set diag [getPerlDiag 40]
	set errf [parseDiagErrf $diag]
	set srcs [parseDiagSrcs $diag]
	set mesg [parseDiagMesg $diag]

	if {[string length $errf]} {
		showPerlDiag $diag [string length $diag] $mesg $errf $srcs
		gotoPerlError $errf $srcs $mesg
		return 1
		
	} else {
		return 0
	}
}

#############################################################################
# Check the MacPerl batch reply for error messages.
#
proc getBatchError {reply} {
	global PerlmodeVars
	set perlErrorWindow {* Perl Error Messages *}
	
	set fatalError 0
	set diag [parseReplyDiag $reply]
	set errf [parseDiagErrf  $diag ]
	set srcs [parseReplySrcs $reply]
	set mesg [parseDiagMesg  $diag ]
	set errn [parseReplyErrn $reply]

	if {$errn} {		
		showPerlDiag $diag $errn $mesg $errf $srcs
		gotoPerlError $errf $srcs $mesg
		set fatalError 1
		
	} elseif {[string length $diag] > 0} {
		showPerlDiag $diag $errn $mesg $errf $srcs
	}
	
	return $fatalError
}

#  get or show diag/errors  #

#############################################################################
# Display the Perl diagnostic output in its own window.
#
proc showPerlDiag {diag {errn 1} {mesg {}} {errf {}} {srcs {}}} {
    global PerlmodeVars	
    set perlErrorWindow {* Perl Error Messages *}
    
    set currWin [lindex [winNames] 0]
    if {[lsearch [winNames] $perlErrorWindow] >= 0} {
	bringToFront $perlErrorWindow
	setWinInfo read-only 0
	deleteText [minPos] [maxPos] 
	insertText $diag
    } else {
	new -n $perlErrorWindow 
	insertText $diag
    }
    
    catch {shrinkWindow 2}
    winReadOnly
    bringToFront $currWin
}

#############################################################################
# Bring up a window containing the bug-ridden Perl code and highlight the
# line at which the error was found.
#
proc gotoPerlError {errf srcs {mesg {}}} {
	global PerlmodeVars scriptFile scriptStart filterHeadLen

	if {$errf == [scriptPath] || $errf == "<AppleEvent>"} {
		set errf $scriptFile
		# Convert it to the line number in the original file
		set srcs [expr $srcs + $scriptStart - $filterHeadLen - 1]
	}
	# ... and leave an informative error message
	#
	if {[string length $mesg]} {
		set mesg "$mesg at Line $srcs"			
	} else {
		set mesg "MacPerl flagged an error at Line $srcs"	
	}
	
	# Bring up the script file and highlight the flagged line
	#
	catch {gotoFileLine $errf $srcs $mesg} fname	
}

#############################################################################
# Read the first block of lines (up to a maximum number) from the MacPerl
# output window.
#
proc getPerlDiag {maxlines} {
	global PerlmodeVars perlName
	set pat0 {^[ \t]*$}

	set lines {}	

	# read first $maxlines of output to the MacPerl window
	# (faster, but assumes error message won't appear at 
	# the end of a lot of output).
	#
	set nlines [sendCountLines $perlName MacPerl]
	set nlines [expr ($nlines > $maxlines)?$maxlines:$nlines]
	if {$nlines > 0} {
		set output [sendGetText $perlName $perlName 1 $nlines]
		
		foreach line [split $output "\r"] {
			if  {[regexp -- $pat0 $line mtch]} {
				break
			} else {
				append lines "$line\n"
			}
		}
	}
	return $lines
}

#  DoScript helpers  #

#############################################################################
# translate special DoScript flags into flags string $usrf
#
proc perlScriptFlags {{flags {}}} {
 	set usrf {}

	if {[lsearch -exact $flags "extract"] >= 0} {
		append usrf { "EXTR" 'true'}
	} elseif {[lsearch -exact $flags "noextract"] >= 0} {
		append usrf { "EXTR" 'fals'}
	}		
	if {[lsearch -exact $flags "debug"] >= 0} {
		append usrf { "DEBG" 'true'}
	} elseif {[lsearch -exact $flags "nodebug"] >= 0} {
		append usrf { "DEBG" 'fals'}
	}		

	if {[lsearch -exact $flags "local"] >= 0} {
		append usrf { "MODE" 'LOCL'}
	} elseif {[lsearch -exact $flags "batch"] >= 0} {
		append usrf { "MODE" 'BATC'}
	} elseif {[lsearch -exact $flags "remote"] >= 0} {
		append usrf { "MODE" 'RCTL'}
	}		
	return $usrf
} 

proc perlScriptArgs {{args {}} {fileargs {}}} {
	set nargs 0
	set argv {}
	
	foreach item [parseWords $args] {
		set item [string trim $item]
		if {[string length $item]} {
			append argv ", [curlyq $item]"
			incr nargs
		}
	}
	foreach filename $fileargs {
		set item [string trim $filename]
		if {[string length $item]} {
			append argv ", [curlyq $item]"
			incr nargs
		}
	}
	return $argv
}

#############################################################################
# General Apple Event routines
# (most of these have been moved to Modes:appleEvents.tcl)
#


#############################################################################
# DoScript for MacPerl 4.1.3
# (runs in "Local" mode under v4.1.4+)
#
proc perlDoScript {appname script {args {}} {fileargs {}} {flags {}} } {
	# form list of quoted "command-line" args
	#
	if {$script != ""} {
		set argv "\[[curlyq [string trim $script]]"
		append argv [perlScriptArgs $args $fileargs]
		append argv "]"
		
		set usrf [perlScriptFlags $flags]
		set reply [eval "AEBuild -t 36000 -r \"$appname\" misc dosc $usrf \"----\" [list $argv] "]
	#	alertnote $reply
	}
}

# DoScript for MacPerl 4.1.4+
# 
# [Q] do I need this for perl via shell? -trf
#
proc perlDoScriptBatch {appname script {args {}} {fileargs {}}} {
	
	# form list of quoted "command-line" args
	#
	if {$script != ""} {
		set argv "\[[curlyq [string trim $script]]"
		append argv [perlScriptArgs $args $fileargs ] 
		append argv "]"
				
		set reply [eval "AEBuild -t 36000 -r \"$appname\" misc dosc MODE BATC \"----\" [list $argv]"]
		
# 		perlDisplayReply $reply

	} else {
		set reply {}
	}
	return $reply
}

# For debugging 
#
proc perlDisplayReply {reply} {
	set currWin [lindex [winNames] 0]
	new -n {*** DoScript Reply **} 
	insertText $reply
		
	winReadOnly
	catch {shrinkWindow 2}
	bringToFront $currWin
}

# DoScript to launch interactive debugger (for MacPerl 4.1.4+)
#
proc perlDoScriptDebug {appname script {args {}} {fileargs {}}} {
	
	# form list of quoted "command-line" args
	#
	if {$script != ""} {
		set argv "\[[curlyq [string trim $script]]"
		append argv [perlScriptArgs "$args debug" $fileargs ] 
		append argv "]"
				
		set reply [eval "AEBuild -t 36000 -r \"$appname\" misc dosc MODE RCTL \"----\" [list $argv]"]

		new -n {** DoScriptDebug Reply **} 
		insertText $reply
			
		winReadOnly
		catch {shrinkWindow 2}

	} else {
		set reply {}
	}
	return $reply
}

#  parse MacPerl output  #

#############################################################################
# Extract various items out of the MacPerl diagnostic output
#

# Name of the file in which the error was found
#
proc parseDiagErrf {diag}	{
	if {![regexp {File '([^']+)'; Line} $diag allofit errf]} { 
		set errf {}
	}
	return $errf
}

# The line number on which the error was found
#
proc parseDiagSrcs {diag}	{
	if {![regexp {File '[^']+'; Line ([0-9]+)} $diag allofit srcs]} { 
		set srcs 0 
	}
	return $srcs
}

# The error message associated with error
#
proc parseDiagMesg {diag} {
	set pat1 {^#(.*)$}
	set pat2 {File '([^']+)'; Line ([0-9]+)}
	
	set errMessage {}
	set errFound 0
	
	foreach line [split $diag "\n"] {
		if {[regexp -- $pat2 $line mtch num]} {
			set errFound 1
		} elseif {[regexp -- $pat1 $line mtch err]} {
			if {$errFound == 0} {
				set errMessage $err
			}
		}
	}
	return $errMessage
}

#############################################################################
# Extract various return parameters out of a MacPerl DoScript reply
#

# Result from batch script
#
proc parseReplyResult {reply} {
	if {![regexp {'?\-\-\-\-'?:([^]*)} $reply allofit result]} { 
		set result {}
	}
	return $result
}

# Standard output of batch script
#
proc parseReplyOutp {reply} {
	if {![regexp {OUTP:([^]*)} $reply allofit outp]} { 
		set outp {}
	}
	return $outp
}

# Diagnostic output of the batch script
#
proc parseReplyDiag {reply}	{
	if {[regexp {diag:([^]*)} $reply allofit diag]}  {
	} else { 
		set diag {}
	}
	return $diag
}

# File alias of the script file in which the error was found
#
proc parseReplyErob {reply}	{
	if {![regexp {erob:alis\((.*)\)} $reply allofit erob]} {
		set erob {} 
	}
	return $erob
}

# First line flagged in error
#
proc parseReplySrcs {reply}	{
	if {![regexp {erng:{srcs:([0-9]+)[^\}]*}} $reply allofit srcs]} { 
		set srcs 0 
	}
	return $srcs
}

# Last line flagged in error
#
proc parseReplySrce {reply}	{
	if {![regexp {erng:{[^\}]*srce:([0-9]+)}} $reply allofit srce]} { 
		set srce 0
	}
	return $srce
}

# Error number
#
proc parseReplyErrn {reply}	{
	if {![regexp {errn:([0-9]+)} $reply allofit errn]} {
		set errn 0
	}
	return $errn
}

#############################################################################
# Read the MacPerl output window and load the contents, if any, into
# a new Alpha window. 
# 
# Modified to direct output to Tcl Shell if perl was called from there -trf
#
proc openPerlOutput {} {
	global PerlmodeVars perlRecycleOutput perlName
	set perlOutputWindow {* Perl Output *}
	
	set output [sendGetText $perlName $perlName]
	if {[string length $output]} {
		if {[win::CurrentTail] == "*tcl shell*"} {
			endOfBuffer
			insertText \r $output
			endOfBuffer 
		} elseif {$PerlmodeVars(perlRecycleOutput) && 
		    [lsearch [winNames] $perlOutputWindow] >= 0} {
		    
			bringToFront $perlOutputWindow
			replaceText [minPos] [maxPos] $output
			catch {shrinkWindow 2}
			setWinInfo dirty 0
			goto [minPos]
		} else {
			new -n $perlOutputWindow
			insertText $output
			catch {shrinkWindow 2}
			setWinInfo dirty 0
			goto [minPos]
		}
	}
}
